    def search_web(self, query: str) -> str:
        """Websuche über Brave Search API"""
        try:
            response = requests.get(
                "https://api.search.brave.com/res/v1/web/search",
                params={"q": query, "count": self.valves.SEARCH_RESULTS_COUNT},
                headers={"X-Subscription-Token": self.valves.BRAVE_API_KEY},
                timeout=10
            )
            response.raise_for_status()
            data = response.json()
            results = data.get("web", {}).get("results", [])[:self.valves.SEARCH_RESULTS_COUNT]

            if not results:
                return "Keine Suchergebnisse gefunden."

            formatted = []
            for r in results:
                title = r.get("title", "Ohne Titel")
                url = r.get("url", "")
                content = r.get("description", "")[:200]
                formatted.append(f"- **{title}**\n  URL: {url}\n  {content}")

            return "\n\n".join(formatted)
        except Exception as e:
            return f"Websuche fehlgeschlagen: {str(e)}"
